Ext.data.JsonP.sol_common_ix_functions_FeedComment({"tagname":"class","name":"sol.common.ix.functions.FeedComment","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.FeedComment.js","href":"sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment"}],"author":[{"tagname":"author","name":"JHR, ELO Digital Office GmbH","email":null}],"version":["1.06.000"],"eloix":true,"requires":["sol.common.DateUtils","sol.common.JsonUtils","sol.common.ObjectUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"data","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-data","meta":{}},{"name":"dynamicData","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-dynamicData","meta":{}},{"name":"file","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-file","meta":{"required":true}},{"name":"key","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-key","meta":{"required":true}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-objId","meta":{"required":true}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"text","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-text","meta":{}},{"name":"userGuid","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-userGuid","meta":{}},{"name":"visibility","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-visibility","meta":{}},{"name":"writeToObjId","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-writeToObjId","meta":{}},{"name":"writeToParent","tagname":"cfg","owner":"sol.common.ix.functions.FeedComment","id":"cfg-writeToParent","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"deleteValue","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-deleteValue","meta":{"private":true}},{"name":"formatText","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-formatText","meta":{"private":true}},{"name":"formatValue","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-formatValue","meta":{"private":true}},{"name":"formatValues","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-formatValues","meta":{"private":true}},{"name":"getValue","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-getValue","meta":{"private":true}},{"name":"getWfMapValue","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-getWfMapValue","meta":{"private":true}},{"name":"getWfNodeValue","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-getWfNodeValue","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-initialize","meta":{}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"method-process","meta":{}},{"name":"RF_sol_function_FeedComment","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"static-method-RF_sol_function_FeedComment","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.FeedComment","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.FeedComment","short_doc":"Writes a feed comment for an archive element. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.FeedComment</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment' target='_blank'>sol.common.ix.functions.FeedComment.js</a></div></pre><div class='doc-contents'><p>Writes a feed comment for an archive element.</p>\n\n<p>The comments will be read from a language <code>file</code> which has to be present in <code>ELOwfBase/Feed/Script Locales</code>.\nA <code>key</code> determines which value from the language file will be used. The feed comments in this file can contain placeholders.\nAn additional <code>data</code> array contains the configuration on how the placeholders will be handled.</p>\n\n<h1>As workflow node</h1>\n\n<p><code>ObjId</code> is set based on the element that the workflow is attached to.\nFollowing configuration should be applied to the comments field.</p>\n\n<pre><code>{\n  \"file\": \"sol.invoice.workflow\",\n  \"key\": \"WORKFLOW.INVOICE.APPROVAL.REJECTED\",\n  \"data\": [ \"INVOICE_NET_AMOUNT\", \"INVOICE_CURRENCY_CODE\" ]\n}\n</code></pre>\n\n<p>The following configuration examples will be (if not stated otherwise) in JavaScript notation (for better readability).\nIf used in a workflow node configuration they need to be converted to JSON notation.</p>\n\n<h1>As IX function call</h1>\n\n<p>In addition to the workflow node configuration the <code>objId</code> must be passed.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_function_FeedComment\", {\n  objId: \"4711\",\n  file: \"sol.invoice.workflow\",\n  key: \"WORKFLOW.INVOICE.APPROVAL.REJECTED\",\n  data: [ \"INVOICE_NET_AMOUNT\", \"INVOICE_CURRENCY_CODE\" ]\n});\n</code></pre>\n\n<h1>Placeholder</h1>\n\n<p>The key in the property file can contain placeholders. Those are curly braces with an index (starting with zero): <code>{0}</code>\nThese placeholders will be replaced with either Sord properties, indexing information, map entries or workflow map entries specified by the data array.\nDatasource is the object specified by <code>objId</code> or on which the workflow runs.</p>\n\n<p>By default, the index field names are used in the data array to determine the values to replace the placeholders:</p>\n\n<pre><code>data: [ \"MY_FIELD\" ]  // abbreviated form, will replace {0} with the value of the index field `MY_FIELD`\n</code></pre>\n\n<p>Advanced placeholder configuration:</p>\n\n<pre><code>data: [ { type: \"SORD\", key: \"name\" } ]  // will replace {0} with the name of the sord\ndata: [ { type: \"GRP\", key: \"MY_FIELD\" } ]  // will replace {0} with the value of the index field `MY_FIELD`\ndata: [ { type: \"MAP\", key: \"MY_MAP\" } ]  // will replace {0} with the value of the map field `MY_MAP`\ndata: [ { type: \"WFMAP\", key: \"MY_WFMAP\" } ]  // will replace {0} with the value of the workflow map field `MY_MAP` (only available in workflow functions)\ndata: [ { type: \"FORMBLOB\", key: \"REASON_OF_REJECTION\", \"deleteAfterUse\": true } ]  // will delete the value after use (only available for type `FORMBLOB`)\ndata: [ { type: \"WFNODE\", node: \"my.node.translation.key\", key: \"comment\" } ]  // only works in workflows, searches the node either by translation key or by node id and writes the node property defined in key\n</code></pre>\n\n<p>Both notations can be mixed.</p>\n\n<h1>Formating</h1>\n\n<p>Values read from fields, can be formatted. An additional configuration will be needed for that.</p>\n\n<p>Currently <code>dateFormat</code>, and <code>eloFormat</code> is supported.</p>\n\n<p>The <code>dateFormat</code> has to be in <a href=\"http://momentjs.com/docs/#/parsing/string-format/\">moment</a> syntax.</p>\n\n<pre><code>data: [ { type: \"GRP\", key: \"MY_DATE_FIELD\", dateFormat: \"DD.MM.YYYY\" } ]  // will output the value of `MY_DATE_FIELD` in the given format e.g. '30.05.2016'\n</code></pre>\n\n<p>The <code>eloFormat</code> currently supports the two values <code>hashtag</code> and <code>mention</code> (or the corresponding shortcuts <code>h</code> or <code>m</code>)</p>\n\n<pre><code>data: [ { type: \"GRP\", key: \"MY_FIELD\", eloFormat: \"hashtag\" } ]  // will output the value of `MY_FIELD` as an elo hashtag\ndata: [ { type: \"GRP\", key: \"MY_FIELD\", eloFormat: \"h\" } ]  // will output the value of `MY_FIELD` as an elo hashtag\ndata: [ { type: \"GRP\", key: \"MY_FIELD\", eloFormat: \"mention\" } ]  // will output the value of `MY_FIELD` as an elo mention\ndata: [ { type: \"GRP\", key: \"MY_FIELD\", eloFormat: \"m\" } ]  // will output the value of `MY_FIELD` as an elo mention\n</code></pre>\n\n<p><code>dateFormat</code> and <code>eloFormat</code> can be combined:</p>\n\n<pre><code>data: [ { type: \"GRP\", key: \"MY_DATE_FIELD\", dateFormat: \"YYYY[_Q]Q\", eloFormat: \"h\" } ]  // will output the value of `MY_DATE_FIELD` as an elo hashtag, e.g. `#2016_Q2`\n</code></pre>\n\n<p>Hashtags can not be longer than 40 characters. If a values should be longer it will be truncated (since 1.06.000).</p>\n\n<p>If formatting should be used, the abbreviated placeholder configuration can not be used.</p>\n\n<h1>Using information boxes in feed comments</h1>\n\n<p>HTML content is allowed if used within localization property files. In order to support colorized information boxes a set of div-containers and colors can be used.</p>\n\n<p>Following locale key will display a yellow box including some information after the message.</p>\n\n<pre><code>CONTRACT.SIGNED=signed the contract.&lt;div class=\"description yellow\"&gt;Information of the box...&lt;/div&gt;\n</code></pre>\n\n<p>By default a set of colors can be used:</p>\n\n<pre><code>&lt;div class=\"description red\"&gt;red box&lt;/div&gt;\n&lt;div class=\"description green\"&gt;green box&lt;/div&gt;\n&lt;div class=\"description redpurple\"&gt;red purple box&lt;/div&gt;\n&lt;div class=\"description yellow\"&gt;yellow box&lt;/div&gt;\n&lt;div class=\"description orange\"&gt;orange box&lt;/div&gt;\n&lt;div class=\"description pink\"&gt;pink box&lt;/div&gt;\n</code></pre>\n\n<p>HTML-Tags must be used with care since that allows breaking the layout. The use of script tags is also forbidden.</p>\n\n<h1>Examples</h1>\n\n<p>For defining new feed action events a language file should be placed in <code>\\Administration\\ELOwf Base\\Feed\\Script Locales</code>. It is recommended seperating language files by the solution.\nIf a contract management solution is used define use a file name that includes a namespace. (e.g. <code>sol.contract</code> or <code>sol.contract_fr</code>)</p>\n\n<p>It is recommended using the default locale file (<code>sol.contract</code>) for the english translation if multiple language files should be supported.\nThis will be used as a fallback for unsupported languages.</p>\n\n<h2>Using property keys</h2>\n\n<p>Contents of file <code>\\Administration\\ELOwf Base\\Feed\\Script Locales\\sol.contract</code>:</p>\n\n<pre><code>CONTRACT.CREATED=created a new contract.\n</code></pre>\n\n<p>Workflow node configuration:</p>\n\n<pre><code>{\n  \"file\": \"sol.contract\",\n  \"key\": \"CONTRACT.CREATED\"\n}\n</code></pre>\n\n<h2>Using data placeholders</h2>\n\n<p>Contents of file <code>\\Administration\\ELOwf Base\\Feed\\Script Locales\\sol.contract</code>:</p>\n\n<pre><code>CONTRACT.CREATED=created a new contract: {0}.\n</code></pre>\n\n<p>Workflow node configuration:</p>\n\n<pre><code>{\n  \"file\": \"sol.contract\",\n  \"key\": \"CONTRACT.CREATED\",\n  \"data\": [\"CONTRACT_NAME\"]\n}\n</code></pre>\n\n<h2>Using information boxes and multiple data placeholders</h2>\n\n<p>Contents of file <code>\\Administration\\ELOwf Base\\Feed\\Script Locales\\sol.contract</code>:</p>\n\n<pre><code>CONTRACT.CONCLUDED=signed the contract.&lt;div class=\"description yellow\"&gt;Comments: {0}&lt;br/&gt;Resposible: {1}&lt;/div&gt;\n</code></pre>\n\n<p>Workflow node configuration:</p>\n\n<pre><code>{\n  \"file\": \"sol.contract\",\n  \"key\": \"CONTRACT.CREATED\",\n  \"data\": [{ \"type\": \"GRP\", \"key\": \"CONTRACT_NAME\" }, { \"type\": \"MAP\", \"key\": \"CONTRACT_RESPONSIBLE\" }]\n}\n</code></pre>\n\n<h2>Using fixed text without localization info</h2>\n\n<p>Workflow node configuration:</p>\n\n<pre><code>{\n  \"text\": \"has created a document {0} with content {1}\",\n  \"data\": [\"Test\", \"xyz\"]\n}\n\n{\n  \"text\": \"\"has created a document {0}\",\n  \"data\": [{ \"type\": \"MAP\", \"key\": \"TEST\" }],\n  \"dynamicData\": true\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.06.000</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-file' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-file' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-file' class='name expandable'>file</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>Resource file from 'ELOwf Base\\Feed\\Script Locales' (without locale extension, e.g. ...</div><div class='long'><p>Resource file from 'ELOwf Base\\Feed\\Script Locales' (without locale extension, e.g. '_de')</p>\n</div></div></div><div id='cfg-key' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-key' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-key' class='name expandable'>key</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The property key for the message</p>\n</div><div class='long'><p>The property key for the message</p>\n</div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-cfg-objId\" rel=\"sol.common.ix.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.ix.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-data' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-data' class='name expandable'>data</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If the key requires additional data, this property should hold a list of group fields to hand over to the feed</p>\n</div><div class='long'><p>If the key requires additional data, this property should hold a list of group fields to hand over to the feed</p>\n</div></div></div><div id='cfg-dynamicData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-dynamicData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-dynamicData' class='name expandable'>dynamicData</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If <code>text</code> is given, this property defines if the property <code>data</code> contains field definitions</p>\n</div><div class='long'><p>If <code>text</code> is given, this property defines if the property <code>data</code> contains field definitions</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-text' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-text' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-text' class='name expandable'>text</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(required, if file and key are not set)\nThe constant text for the message if locale extension is not used</p>\n</div><div class='long'><p>(required, if file and key are not set)\nThe constant text for the message if locale extension is not used</p>\n</div></div></div><div id='cfg-userGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-userGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-userGuid' class='name expandable'>userGuid</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>If set the comment will be written under the given users name. ...</div><div class='long'><p>If set the comment will be written under the given users name.\nThis is only allowed if executing user has administrative privileges and cannot be used if used as onEnter or onExit node.</p>\n</div></div></div><div id='cfg-visibility' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-visibility' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-visibility' class='name expandable'>visibility</a> : String[]|Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>If set the comment will be visible to the given users or groups only. ...</div><div class='long'><p>If set the comment will be visible to the given users or groups only.\nIf this contains strings, they serve as user names. If it contains objects, they have to contain a type (e.g. \"GRP\") and a key property.</p>\n</div></div></div><div id='cfg-writeToObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-writeToObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-writeToObjId' class='name expandable'>writeToObjId</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>If set the feed for the given object used used instead. ...</div><div class='long'><p>If set the feed for the given object used used instead.\nThis allows retrieving data from the current object and write feed actions to another object.</p>\n</div></div></div><div id='cfg-writeToParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-cfg-writeToParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-cfg-writeToParent' class='name expandable'>writeToParent</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>If true then the comment will be written to the parent of the element ...</div><div class='long'><p>If true then the comment will be written to the parent of the element</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-deleteValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-deleteValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-deleteValue' class='name expandable'>deleteValue</a>( <span class='pre'>sord, dataConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-formatText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-formatText' class='name expandable'>formatText</a>( <span class='pre'>text, data</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : String<div class='sub-desc'><p>e.g.\"has created a document {0} with content {1}\"</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>e.g. [\"Test\", \"xyz\"]</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>formmatted text \"has created a document Test with content \"xyz\"\"</p>\n</div></li></ul></div></div></div><div id='method-formatValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-formatValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-formatValue' class='name expandable'>formatValue</a>( <span class='pre'>value, dataConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-formatValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-formatValues' class='name expandable'>formatValues</a>( <span class='pre'>values, dataConfig</span> ) : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>sord, dataConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWfMapValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-getWfMapValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-getWfMapValue' class='name expandable'>getWfMapValue</a>( <span class='pre'>dataConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWfNodeValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-getWfNodeValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-getWfNodeValue' class='name expandable'>getWfNodeValue</a>( <span class='pre'>dataConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dataConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Config</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes the feed comment for the element. ...</div><div class='long'><p>Writes the feed comment for the element.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_FeedComment' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-static-method-RF_sol_function_FeedComment' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-static-method-RF_sol_function_FeedComment' class='name expandable'>RF_sol_function_FeedComment</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FeedComment'>sol.common.ix.functions.FeedComment</span><br/><a href='source/sol.common.ix.functions.FeedComment.html#sol-common-ix-functions-FeedComment-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FeedComment-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});